/******************************************************************************
 x_CAdaApp.c

				CAdaApp "Lower-Layer" Application Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 2:55 PM Sat, Oct 2, 1993

	This file is rewritten each time you generate code. You should not
	make changes to this file; changes should go in the CAdaApp.c
	file, instead.

	If you want to change how Classy generates this file, you can
	change the template for this file. It is "_App.c" in the Classy
	Templates folder.

 ******************************************************************************/

#include "x_CAdaApp.h"

#include "CAdaApp.h"

#include "References.h"
#include "CLibrary.h"
#include "CCompilerOptions.h"
#include "CLibrary.h"
#include "CExecuteOptions.h"
#include <CBartender.h>
#include <Commands.h>
#include <CDesktop.h>
#include <CFile.h>
#include <CFWDesktop.h>
#include <CList.h>
#include <Packages.h>
#include <TBUtilities.h>

#include "CAboutBox.h"
#include "CCompilerOptions.h"
#include "CCompiling.h"
#include "CExecuteOptions.h"
#include "CFind.h"
#include "CGotoLine.h"
#include "CLibrary.h"
#include "CSlots.h"
#include "CUnits.h"

extern OSType		gSignature;			/* Creator for Application's files	*/
extern CBartender	*gBartender;		/* Manages all menus				*/
extern CDesktop		*gDesktop;			/* The visible Desktop				*/

#define ALRTabout 500

	// Define symbols for commands handled by this class
	// Prevents a recompile every time any command changed.

#define cmdOpenFile1 512
#define cmdOpenFile2 513
#define cmdOpenFile3 515
#define cmdOpenFile4 516
#define cmdOpenFile5 517
#define cmdOpenFile6 518
#define cmdCompileOptions 519
#define cmdOpenMonitor 537
#define cmdOpenLibrary 539
#define cmdChangeLibrary 541
#define cmdBindOne 542
#define cmdExecuteOne 543
#define cmdOpenOther 547
#define cmdCloseUserLibrary 549
#define cmdMemory 550
#define cmdWLibrary 553
#define cmdCompileOther 555
#define cmdNewUserLibrary 554
#define cmdExecuteOptions 557


/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 Ix_CAdaApp
 
		Initialize an Application.
 ******************************************************************************/

void	x_CAdaApp::Ix_CAdaApp(short extraMasters, Size aRainyDayFund,
									Size aCriticalBalance, Size aToolboxBalance)

{
	IApplication(extraMasters, aRainyDayFund, aCriticalBalance, aToolboxBalance);

}


/******************************************************************************
 ForceClassReferences	{OVERRIDE}
 
	Reference classes that might do object I/O.
 ******************************************************************************/

void x_CAdaApp::ForceClassReferences(void)

{
	Boolean alwaysFalse = FALSE;
	CObject *dummy;

	CApplication::ForceClassReferences();

											/* From References.c			*/
	ReferenceStdClasses();					/*	 See template file Ref		*/
	
	if (alwaysFalse)
	{
		member(dummy, CSlots);
		member(dummy, CUnits);
	}
}


/******************************************************************************
 MakeDesktop	{OVERRIDE}
 
	Make a floating desktop
 ******************************************************************************/

void	x_CAdaApp::MakeDesktop()
{
	gDesktop = new(CFWDesktop);			/* Use a floating Desktop			*/
	((CFWDesktop*)gDesktop)->IFWDesktop(this);
}	


/******************************************************************************
 SetUpFileParameters	{OVERRIDE}

	Specify the kinds of files your application opens
 ******************************************************************************/

void x_CAdaApp::SetUpFileParameters()
{
	CApplication::SetUpFileParameters();

		// File types as defined in CAdaApp.h

	sfNumTypes = kNumFileTypes;
	sfFileTypes[0] = kTextSource;
	sfFileTypes[1] = kListingType;
	gSignature = 'GADA';
}


/******************************************************************************
 SetUpMenus {OVERRIDE}

		Set up the menus after first creating any floating/tearoff
		windows. The latter must be done before the bartender inits.
 ******************************************************************************/

void x_CAdaApp::SetUpMenus()
{
	CApplication::SetUpMenus();
}


/**** C O M M A N D   M E T H O D S ****/


/******************************************************************************
 DoCommand	{OVERRIDE}

	Handle application commands
 ******************************************************************************/

void x_CAdaApp::DoCommand(long theCommand)

{
	switch (theCommand)
	{
		case cmdAbout:

				// Simple About alert. Subclasses will probably
				// trap this command to do something sexier.

			PositionDialog('ALRT', ALRTabout);
			InitCursor();
			ParamText("\pCAdaApp", "\pThe George Washington University", "\p", "\p");
			Alert(ALRTabout, NULL);
			break;

		case cmdOpenFile1:
			DoCmdOpenFile1();
			break;

		case cmdOpenFile2:
			DoCmdOpenFile2();
			break;

		case cmdOpenFile3:
			DoCmdOpenFile3();
			break;

		case cmdOpenFile4:
			DoCmdOpenFile4();
			break;

		case cmdOpenFile5:
			DoCmdOpenFile5();
			break;

		case cmdOpenFile6:
			DoCmdOpenFile6();
			break;

		case cmdCompileOptions:
			DoCmdCompileOptions();
			break;

		case cmdOpenMonitor:
			DoCmdOpenMonitor();
			break;

		case cmdOpenLibrary:
			DoCmdOpenLibrary();
			break;

		case cmdChangeLibrary:
			DoCmdChangeLibrary();
			break;

		case cmdBindOne:
			DoCmdBindOne();
			break;

		case cmdExecuteOne:
			DoCmdExecuteOne();
			break;

		case cmdOpenOther:
			break;

		case cmdCloseUserLibrary:
			DoCmdCloseUserLibrary();
			break;

		case cmdMemory:
			break;

		case cmdWLibrary:
			break;

		case cmdCompileOther:
			break;

		case cmdNewUserLibrary:
			break;

		case cmdExecuteOptions:
			DoCmdExecuteOptions();
			break;

		default:
			CApplication::DoCommand(theCommand);
			break;
	}
}


/******************************************************************************
 UpdateMenus {OVERRIDE}

		Enable menus which generate commands handled by this class.
 ******************************************************************************/

void x_CAdaApp::UpdateMenus()

{
	CApplication::UpdateMenus();

	gBartender->EnableCmd(cmdOpenFile1);
	gBartender->EnableCmd(cmdOpenFile2);
	gBartender->EnableCmd(cmdOpenFile3);
	gBartender->EnableCmd(cmdOpenFile4);
	gBartender->EnableCmd(cmdOpenFile5);
	gBartender->EnableCmd(cmdOpenFile6);
	gBartender->EnableCmd(cmdCompileOptions);
	gBartender->EnableCmd(cmdOpenMonitor);
	gBartender->EnableCmd(cmdOpenLibrary);
	gBartender->EnableCmd(cmdChangeLibrary);
	gBartender->EnableCmd(cmdBindOne);
	gBartender->EnableCmd(cmdExecuteOne);
	gBartender->EnableCmd(cmdOpenOther);
	gBartender->EnableCmd(cmdCloseUserLibrary);
	gBartender->EnableCmd(cmdMemory);
	gBartender->EnableCmd(cmdWLibrary);
	gBartender->EnableCmd(cmdCompileOther);
	gBartender->EnableCmd(cmdNewUserLibrary);
	gBartender->EnableCmd(cmdExecuteOptions);
}


/******************************************************************************
 DoCmdOpenFile1

		Respond to cmdOpenFile1 command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenFile1()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdOpenFile2

		Respond to cmdOpenFile2 command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenFile2()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdOpenFile3

		Respond to cmdOpenFile3 command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenFile3()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdOpenFile4

		Respond to cmdOpenFile4 command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenFile4()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdOpenFile5

		Respond to cmdOpenFile5 command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenFile5()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdOpenFile6

		Respond to cmdOpenFile6 command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenFile6()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdCompileOptions

		Respond to cmdCompileOptions command.
 ******************************************************************************/

void x_CAdaApp::DoCmdCompileOptions()

{
	CCompilerOptions		*dialog;
	
  		// Respond to command by opening a dialog

	dialog = new CCompilerOptions;
	dialog->ICCompilerOptions(this);
	dialog->BeginDialog();

									/* cmdOK is usually right, but the		*/
	dialog->DoModalDialog(cmdOK);	/*	 but dialog itself may know better	*/
	ForgetObject(dialog);
}


/******************************************************************************
 DoCmdOpenMonitor

		Respond to cmdOpenMonitor command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenMonitor()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdOpenLibrary

		Respond to cmdOpenLibrary command.
 ******************************************************************************/

void x_CAdaApp::DoCmdOpenLibrary()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdChangeLibrary

		Respond to cmdChangeLibrary command.
 ******************************************************************************/

void x_CAdaApp::DoCmdChangeLibrary()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdBindOne

		Respond to cmdBindOne command.
 ******************************************************************************/

void x_CAdaApp::DoCmdBindOne()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdExecuteOne

		Respond to cmdExecuteOne command.
 ******************************************************************************/

void x_CAdaApp::DoCmdExecuteOne()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdCloseUserLibrary

		Respond to cmdCloseUserLibrary command.
 ******************************************************************************/

void x_CAdaApp::DoCmdCloseUserLibrary()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdExecuteOptions

		Respond to cmdExecuteOptions command.
 ******************************************************************************/

void x_CAdaApp::DoCmdExecuteOptions()

{
	CExecuteOptions		*dialog;
	
  		// Respond to command by opening a dialog

	dialog = new CExecuteOptions;
	dialog->ICExecuteOptions(this);
	dialog->BeginDialog();

									/* cmdOK is usually right, but the		*/
	dialog->DoModalDialog(cmdOK);	/*	 but dialog itself may know better	*/
	ForgetObject(dialog);
}


/**** D O C U M E N T   M E T H O D S ****/


/******************************************************************************
 CreateDocument	{OVERRIDE}

	Make a new document when user chooses New from file menu.
	This method is entirely generic except for the document class.
 ******************************************************************************/

void x_CAdaApp::CreateDocument()

{
}


/******************************************************************************
 OpenDocument	{OVERRIDE}

	Open a document when user chooses Open from file menu.
	For multiple document types, this method assumes that each
	document is associated with a single file type. 
 ******************************************************************************/

void x_CAdaApp::OpenDocument(SFReply *macSFReply)

{
}




/******************************************************************************
 FileAlreadyOpen

	If file already in use return TRUE and bring owning document's
	window to the foreground.  Sent from document before opening.
 ******************************************************************************/

	static Boolean EqualFile(CObject *obj, long param)
	{
		FSSpec		theFileSpec;
		CFile		*theFile;
		FSSpec		*theParam = (FSSpec*) param;

		if (member(obj, CDocument))
		{
			theFile = ((CDocument*)obj)->itsFile;
			if (theFile == NULL)
				return FALSE;
			theFile->GetFSSpec(&theFileSpec);
			return theFileSpec.vRefNum == theParam->vRefNum
				&& theFileSpec.parID == theParam->parID
				&& !IUEqualString(theFileSpec.name, theParam->name);
		}
		return FALSE;
	}

Boolean x_CAdaApp::FileAlreadyOpen(
	CFile		*aFile)

{
	FSSpec		fileSpec;
	CDirector	*theDirector = NULL;

	aFile->GetFSSpec(&fileSpec);
	if (itsDirectors)						/* Search for matching file		*/
		theDirector = (CDirector*) itsDirectors->FindItem1(EqualFile, (long) &fileSpec);
	if (theDirector)						/* If find one, bring to front	*/
		theDirector->GetWindow()->Select();
	return theDirector != NULL;				/* Tell caller					*/
}
